--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- Base class that represents the nodes of a scene graph. A node can have any number of child nodes.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/types/niNode).
--- @class niNode : niAVObject, niObjectNET, niObject
--- @field children niAVObject[]|niAmbientLight[]|niAutoNormalParticles[]|niBSAnimationNode[]|niBSParticleNode[]|niBillboardNode[]|niCamera[]|niCollisionSwitch[]|niDirectionalLight[]|niNode[]|niParticles[]|niPointLight[]|niRotatingParticles[]|niSortAdjustNode[]|niSpotLight[]|niSwitchNode[]|niTextureEffect[]|niTriShape[] *Read-only*. The children of the node. Can have `nil` entries.
--- @field effectList niDynamicEffectLinkedList *Read-only*. The effect list of the node. Attached effects affect the node and all of its child subtree geometry.
niNode = {}

--- Creates a new, empty NiNode.
--- @return niBSAnimationNode|niBSParticleNode|niBillboardNode|niCollisionSwitch|niNode|niSortAdjustNode|niSwitchNode node No description yet available.
function niNode.new() end

--- Attaches the child to the children list of the node. Doesn't check to see if the object is already in the child list.
--- @param child niAVObject|niAmbientLight|niAutoNormalParticles|niBSAnimationNode|niBSParticleNode|niBillboardNode|niCamera|niCollisionSwitch|niDirectionalLight|niNode|niParticles|niPointLight|niRotatingParticles|niSortAdjustNode|niSpotLight|niSwitchNode|niTextureEffect|niTriShape No description yet available.
--- @param useFirstAvailable? boolean *Default*: `false`. Use the first available space in the list. If `false` appends the child at the end of the list.
function niNode:attachChild(child, useFirstAvailable) end

--- Attaches a dynamic effect to the node. It will not attach the same effect twice.
--- @param effect niAmbientLight|niDirectionalLight|niDynamicEffect|niPointLight|niSpotLight|niTextureEffect No description yet available.
function niNode:attachEffect(effect) end

--- Calculates and creates a bounding box for the object. The existing bounding box, if any, will not be used, a fresh one will always be calculated.
--- @param args? niNode.createBoundingBox.args This table accepts the following values:
--- 
--- `accurateSkinned?`: boolean — *Default*: `false`. If true, [`niSkinInstance`](http://mwse.github.io/MWSE/types/niSkinInstance/?h=niskininstan) deformations will be applied before calculating the bounding box. This has an additional performance cost
--- 
--- `observeAppCullFlag?`: boolean — *Default*: `false`. If true, objects that have the [`appCulled`](http://mwse.github.io/MWSE/types/niAVObject/#appculled) flag set will be ignored.
--- 
--- `onlyActiveChildren?`: boolean — *Default*: `false`. If true, only the [`active children`](https://mwse.github.io/MWSE/types/niSwitchNode/#getactivechild) will be processed.
--- @return tes3boundingBox boundingBox The newly created bounding box.
function niNode:createBoundingBox(args) end

---Table parameter definitions for `niNode.createBoundingBox`.
--- @class niNode.createBoundingBox.args
--- @field accurateSkinned? boolean *Default*: `false`. If true, [`niSkinInstance`](http://mwse.github.io/MWSE/types/niSkinInstance/?h=niskininstan) deformations will be applied before calculating the bounding box. This has an additional performance cost
--- @field observeAppCullFlag? boolean *Default*: `false`. If true, objects that have the [`appCulled`](http://mwse.github.io/MWSE/types/niAVObject/#appculled) flag set will be ignored.
--- @field onlyActiveChildren? boolean *Default*: `false`. If true, only the [`active children`](https://mwse.github.io/MWSE/types/niSwitchNode/#getactivechild) will be processed.

--- Detaches all children from the children list of the node.
function niNode:detachAllChildren() end

--- Detaches all dynamic effect from the effect list of the node.
function niNode:detachAllEffects() end

--- Detaches the child from the children list of the node. Returns the detached child.
--- @param child niAVObject|niAmbientLight|niAutoNormalParticles|niBSAnimationNode|niBSParticleNode|niBillboardNode|niCamera|niCollisionSwitch|niDirectionalLight|niNode|niParticles|niPointLight|niRotatingParticles|niSortAdjustNode|niSpotLight|niSwitchNode|niTextureEffect|niTriShape No description yet available.
--- @return niAVObject|niAmbientLight|niAutoNormalParticles|niBSAnimationNode|niBSParticleNode|niBillboardNode|niCamera|niCollisionSwitch|niDirectionalLight|niNode|niParticles|niPointLight|niRotatingParticles|niSortAdjustNode|niSpotLight|niSwitchNode|niTextureEffect|niTriShape detachedChild No description yet available.
function niNode:detachChild(child) end

--- Detaches the child at the specified index from the children list of the node. Returns the detached child.
--- @param index integer No description yet available.
--- @return niAVObject|niAmbientLight|niAutoNormalParticles|niBSAnimationNode|niBSParticleNode|niBillboardNode|niCamera|niCollisionSwitch|niDirectionalLight|niNode|niParticles|niPointLight|niRotatingParticles|niSortAdjustNode|niSpotLight|niSwitchNode|niTextureEffect|niTriShape detachedChild No description yet available.
function niNode:detachChildAt(index) end

--- Detaches the given dynamic effect from the effect list of the node, if it was present. Has no effect if the effect wasn't attached to the node.
--- @param effect niAmbientLight|niDirectionalLight|niDynamicEffect|niPointLight|niSpotLight|niTextureEffect No description yet available.
function niNode:detachEffect(effect) end

--- Gets the effect of the given type.
--- @param type ni.dynamicEffectType Use the values from [`ni.dynamicEffectType`](https://mwse.github.io/MWSE/references/ni/dynamic-effect-types/) table.
--- @return niAmbientLight|niDirectionalLight|niDynamicEffect|niPointLight|niSpotLight|niTextureEffect|nil effect No description yet available.
function niNode:getEffect(type) end

